using System;
using Server;
using Server.Misc;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a forest elf corpse" )]
	public class ForestElfArcher : BaseCreature
	{
		private DateTime m_HidingDelay = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 10, 20 ) );
		private DateTime m_NextSpeechTime = DateTime.Now;
		private DateTime m_Summon = DateTime.Now;
		
		public override bool ShowFameTitle{ get{ return false; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 2; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.LightningArrow;
					case 1: return WeaponAbility.ForceArrow;
					case 2: return WeaponAbility.SerpentArrow;
			}
		}
		
		[Constructable]
		public ForestElfArcher() : base( AIType.AI_Archer, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Hue = Race.Elf.RandomSkinHue();
			Name = NameList.RandomName( "elven" );
			
			if ( Female = Utility.RandomBool() )
			{
				Body = 606;
			}
			else
			{
				Body = 605;
			}
			// hair, facial hair
			HairItemID = Race.Elf.RandomHair( Female );
			HairHue = Race.Elf.RandomHairHue();
			Race = Race.Elf;
			Title = "the forest elf";
			
			SetStr( 186, 200 );
			SetDex( 120, 145 );
			SetInt( 61, 75 );

			SetDamage( 15, 27 );
			SetHits( 381, 395 );
			SetMana( 450, 500 );
			
			// 			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 25, 50 );
			SetResistance( ResistanceType.Fire, 25, 50 );
			SetResistance( ResistanceType.Cold, 25, 50 );
			SetResistance( ResistanceType.Poison, 25, 50 );
			SetResistance( ResistanceType.Energy, 25, 30 );

			SetSkill( SkillName.SpiritSpeak, 80.0, 100.0 );
			SetSkill( SkillName.MagicResist, 80.0, 110.0 );
			SetSkill( SkillName.Archery, 80.0, 110.0 );
			SetSkill( SkillName.Tactics, 80.0, 110.0 );
			SetSkill( SkillName.Wrestling, 80.0, 110.0 );
			SetSkill( SkillName.Anatomy, 80.0, 110.0 );
			SetSkill( SkillName.ArmsLore, 80.0, 110.0 );
			SetSkill( SkillName.Hiding, 100.1 );
			SetSkill( SkillName.DetectHidden, 100.1, 120.0 );
			SetSkill( SkillName.Stealth, 300.0 );
			SetSkill( SkillName.AnimalTaming, 120.0 );
			SetSkill( SkillName.AnimalLore, 120.0 );
			SetSkill( SkillName.Poisoning, 50.0, 100.0 );
			
			// outfit
			BaseArmor arms = new LeafArms();
			//          arms.Resource = CraftResource.BarbedLeather;
			arms.Movable = false;
			AddItem( arms );
			if ( this.Female )
			{
				BaseArmor femalechest = new FemaleLeafChest();
				//          femalechest.Resource = CraftResource.BarbedLeather;
				femalechest.Movable = false;
				AddItem( femalechest );
			}
			else
			{
				BaseArmor chest = new LeafChest();
				//          chest.Resource = CraftResource.BarbedLeather;
				chest.Movable = false;
				AddItem( chest );
			}
			BaseArmor gloves = new LeafGloves();
			//          gloves.Resource = CraftResource.BarbedLeather;
			gloves.Movable = false;
			AddItem( gloves );
			BaseArmor gorget = new LeafGorget();
			//          gorget.Resource = CraftResource.BarbedLeather;
			gorget.Movable = false;
			AddItem( gorget );
			BaseArmor legs = new LeafLegs();
			//          legs.Resource = CraftResource.BarbedLeather;
			legs.Movable = false;
			AddItem( legs );
			if ( Utility.RandomDouble() < 0.3 )
			{
				Item cloak = new Cloak();
				cloak.Hue = Utility.RandomNeutralHue();
				AddItem( cloak );
			}
			if ( Utility.RandomDouble() < 0.1 )
			{
				if ( this.Female )
				{
					Item femalerobe = new FemaleElvenRobe();
					if (Utility.RandomDouble() < 0.3)
						femalerobe.Hue = Utility.RandomNeutralHue();
					femalerobe.Movable = ( Utility.RandomDouble() < 0.001 ) ? true : false;
					AddItem( femalerobe );
				}
				else
				{
					Item robe = new MaleElvenRobe();;
					if (Utility.RandomDouble() < 0.3)
						robe.Hue = Utility.RandomNeutralHue();
					robe.Movable = ( Utility.RandomDouble() < 0.001 ) ? true : false;
					AddItem( robe );
				}
			}
			else
			{
				if ( Utility.RandomBool() )
				{
					Item belt = new WoodlandBelt();
					belt.Movable = false;
					AddItem( belt );
				}
			}
			Item boots = new ElvenBoots();
			boots.Movable = false;
			AddItem( boots );
			//talismany
			if ( Utility.RandomDouble() < 0.002 )
			{
				Item wisdomofancientforest = new WisdomOfAncientForest();
				AddItem( wisdomofancientforest );
			}
			else
			{
				Item talisman = new RandomTalisman();
				talisman.Movable = false;
				AddItem( talisman );
			}

			switch ( Utility.Random( 5 ) )
			{
				case 0:
					{
						BaseArmor ravenhelm = new RavenHelm();
						//                ravenhelm.Resource = CraftResource.Obsidian;
						ravenhelm.Movable = false;
						AddItem( ravenhelm );
					}
					break;
				case 1:
					{
						BaseArmor royalcirclet = new RoyalCirclet();
						//                royalcirclet.Resource = CraftResource.Obsidian;
						royalcirclet.Movable = false;
						AddItem( royalcirclet );
					}
					break;
				case 2:
					{
						BaseArmor vulturehelm = new VultureHelm();
						//                vulturehelm.Resource = CraftResource.Obsidian;
						vulturehelm.Movable = false;
						AddItem( vulturehelm );
					}
					break;
				case 3:
					{
						BaseArmor wingedhelm = new WingedHelm();
						//                wingedhelm.Resource = CraftResource.Obsidian;
						wingedhelm.Movable = false;
						AddItem( wingedhelm );
					}
					break;
				case 4:
					{
						BaseArmor gemmedcirclet = new GemmedCirclet();
						//                gemmedcirclet.Resource = CraftResource.Obsidian;
						gemmedcirclet.Movable = false;
						AddItem( gemmedcirclet );
					}
					break;
			}

			switch ( Utility.Random( 2 ))
			{
				case 0:
					{
						BaseRanged elvencompositelongbow = new ElvenCompositeLongbow();
						if (Utility.RandomDouble() < 0.3)
							elvencompositelongbow.Resource = CraftResource.Ash;
						elvencompositelongbow.Movable = false;
						AddItem( elvencompositelongbow );
					}
					break;
				case 1:
					{
						BaseRanged magicalshortbow = new MagicalShortbow();
						if (Utility.RandomDouble() < 0.3)
							magicalshortbow.Resource = CraftResource.Ash;
						magicalshortbow.Movable = false;
						AddItem( magicalshortbow );
					}
					break;
			}
			
			switch ( Utility.Random( 2 ))
			{
				case 0:
					{
						BaseQuiver elvenquiver = new ElvenQuiver();
						//                elvenquiver.Lootype = Lootype.Blessed;
						elvenquiver.Movable = false;
						AddItem( elvenquiver );
					}
					break;
				case 1:
					{
						BaseQuiver ultimatequiver = new UltimateQuiver();
						//                ultimatequiver.Lootype = Lootype.Blessed;
						ultimatequiver.Movable = false;
						AddItem( ultimatequiver );
					}
					break;
			}
			//end outfit
			PackItem( new Arrow( Utility.RandomMinMax( 10, 30 ) ) );
			PackItem( new Bandage( Utility.RandomMinMax( 5, 15 ) ) );
			// 			PackGold( 100, 200 );
			
			Fame = 5000;
			Karma = -7000;
			VirtualArmor = 0;
			
			if ( Utility.RandomDouble() < 0.1 )
			{
				if ( Utility.RandomBool() )
					new CuSidhe().Rider = this;
				else
					new Reptalon().Rider = this;
			}
			
			// if ( Utility.RandomDouble() < 0.0055 )
			// {
				// switch ( Utility.Random( 5 ))
				// {
					// case 0: PackItem( new RangerArms() ); break;
					// case 1: PackItem( new RangerGloves() ); break;
					// case 2: PackItem( new RangerGorget() ); break;
					// case 3: PackItem( new RangerChest() ); break;
					// case 4: PackItem( new RangerLegs() ); break;
				// }
			// }
		}
		
		// 		public override void OnDeath( Container c )
		// 		{
		// 			base.OnDeath( c );
//
		// 			if ( Utility.RandomDouble() < 0.05 )
		//             c.DropItem( new ForestElvesAmulet() );
		// 		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
		}
		
		public override bool IsNotScaredOfDeath{ get{ return Utility.RandomBool(); } } //neutika pri malem poctu hp - sance 50%
		
		public override void OnThink()
		{
			m_HidingDelay = Ability.HideSelf( this, m_HidingDelay, Utility.RandomMinMax( 10, 15 ), 5 );
			// 			base.OnThink();
		}

		public override void OnMovement( Mobile m, Point3D oldLocation )
		{
			if ( !this.Hidden && this.Frozen && this.Combatant != null )
			{
				this.Frozen = false;
			}
			
			if ( !this.Hidden && DateTime.Now > m_NextSpeechTime && m.InRange( this, 3 ) && m is PlayerMobile )
			{
				m_NextSpeechTime = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 10, 20 ) );
				SayRandom( DarkElf.ElfSay, this );
				this.Move( GetDirectionTo( m.Location ) );
			}
		}
		
		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;
			if   ( mount != null )
				mount.Rider = null;
			
			if ( mount is Mobile )
			{
				if ( Utility.RandomDouble() < 0.95 || this.Map == Map.Underworld )
					((Mobile)mount).Delete();
				else
					((Mobile)mount).Combatant = this.Combatant;
			}
			
			return base.OnBeforeDeath();
		}
		
		public override void OnActionCombat()
		{
			if ( !this.Hidden && this.Combatant != null && DateTime.Now > m_Summon && Utility.RandomDouble() < 0.3 )
			{
				Mobile target = this.Combatant;
				
				this.Frozen = false;
				this.Say( Utility.RandomBool() ? "Tua amin onna!" : "Ndengina Ho!" ); //help me / kill him

				Map map = this.Map;

				if ( map == null )
					return;

				BaseCreature animal = null;

				switch ( Utility.Random( 4 ) )
				{
						case 0: animal = new MeerGrizzlyBear(); break;
						case 1: animal = new MeerGreatHart(); break;
						case 2: animal = new MeerDireWolf(); break;
						case 3: animal = new MeerPanther(); break;
				}

				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 2 ) - 1;
					int y = Y + Utility.Random( 2 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}

				animal.Team = this.Team;
				animal.MoveToWorld( loc, map );
				animal.Combatant = target;

				m_Summon = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 20, 45 ) );
			}
			base.OnActionCombat();
		}
		
		private static void SayRandom( string[] say, Mobile m )
		{
			m.Say( say[Utility.Random( say.Length )] );
		}
		
		public ForestElfArcher( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}
